<?php
/**
 * 2007-2015 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author PrestaShop SA <contact@prestashop.com>
 *  @copyright  2007-2015 PrestaShop SA
 *  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

require_once(_PS_MODULE_DIR_ . 'mensagiaprestashop/classes/MensagiaSDK.php');
require_once(_PS_MODULE_DIR_ . 'mensagiaprestashop/models/MensagiaSMSNotification.php');

class MensagiaHookActionController extends Module
{
    private static $instance;
    private $mensagiaSDK;

    public function __construct()
    {
        $this->mensagiaSDK = new MensagiaSDK();
    }

    public static function getInstance()
    {
        if (!isset(self::$instance)) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    public function getDataActionOrderStatusPostUpdate(
        $id_order,
        $order,
        $customer,
        $address,
        $currency,
        $carrier,
        $product,
        $employee,
        $customer_question
    ) {
        $data = array();

        $data['{customer_id}']                  = isset($customer->id) ? $customer->id : "";
        $data['{customer_firstname}']           = isset($customer->firstname) ? $customer->firstname : "" ;
        $data['{customer_lastname}']            = isset($customer->lastname) ? $customer->lastname : "";
        $data['{customer_email}']               = isset($customer->email) ? $customer->email : "";
        $data['{customer_company}']             = isset($address->company) ? $address->company : "";
        $data['{customer_address1}']            = isset($address->address1) ? $address->address1 : "";
        $data['{customer_address2}']            = isset($address->address2) ? $address->address2 : "";
        $data['{customer_postcode}']            = isset($address->postcode) ? $address->postcode : "";
        $data['{customer_city}']                = isset($address->city) ? $address->city : "";
        $data['{customer_country}']             = isset($address->country) ? $address->country : "";
        $data['{customer_state}']               = isset($address->state) ? $address->state : "";
        $data['{customer_phone}']               = isset($address->phone) ? $address->phone : "";
        $data['{customer_mobile}']              = isset($address->phone_mobile) ? $address->phone_mobile : "";
        $data['{customer_vat_number}']          = isset($address->vat_number) ? $address->vat_number : "";

        $data['{shop_name}']                    = (Configuration::get('PS_SHOP_NAME')) ?
            Configuration::get('PS_SHOP_NAME') : "";
        $data['{shop_email}']                   = (Configuration::get('PS_SHOP_EMAIL')) ?
            Configuration::get('PS_SHOP_EMAIL') : "";
        $data['{shop_domain}']                  = (Configuration::get('PS_SHOP_DOMAIN')) ?
            Configuration::get('PS_SHOP_DOMAIN') : "";
        $data['{shop_phone}']                   = (Configuration::get('PS_SHOP_PHONE')) ?
            Configuration::get('PS_SHOP_PHONE') : "";


        $delivery_date  = isset($order->delivery_date) ? $order->delivery_date : "";
        $invoice_date   = isset($order->invoice_date) ? $order->invoice_date : "";

        if ($delivery_date) {
            $delivery_date_es = $this->spanishDates($delivery_date);
        }

        if ($invoice_date) {
            $invoice_date_es  = $this->spanishDates($invoice_date);
        }

        $data['{order_id}']                     = isset($id_order) ? $id_order : "";
        $data['{order_payment}']                = isset($order->payment) ? $order->payment : "";
        $data['{order_total_paid}']             = isset($order->total_paid) ? number_format(
            $order->total_paid,
            2,
            ',',
            '.'
        ) : "";
        $data['{order_currency}']               = isset($currency->iso_code) ?  $currency->iso_code : "";
        $data['{order_delivery_format_en}']     = isset($delivery_date) ? $delivery_date : "";
        $data['{order_delivery_format_es}']     = isset($delivery_date_es) ? $delivery_date_es : "";
        $data['{order_invoice_format_es}']      = isset($invoice_date_es) ? $invoice_date_es : "";
        $data['{order_invoice_format_en}']      = isset($invoice_date) ? $invoice_date : "";
        $data['{order_shipping_number}']        = isset($order->shipping_number) ? $order->shipping_number : "";
        $data['{order_reference}']              = isset($order->reference) ? $order->reference : "";
        $data['{carrier_id}']                   = isset($order->id_carrier) ? $order->id_carrier : "";
        $data['{carrier_name}']                 = isset($carrier->name) ? $carrier->name : "";

        $data['{product_id}']                   = isset($product->id) ? $product->id : "";
        $data['{product_name}']                 = isset($product->name[1]) ? $product->name[1] : "";
        $data['{product_ref}']                  = isset($product->reference) ? $product->reference : "";

        $data['{employee_id}']                  = isset($employee->id) ? $employee->id : "";
        $data['{employee_firstname}']           = isset($employee->firstname) ? $employee->firstname : "";
        $data['{employee_lastname}']            = isset($employee->lastname) ? $employee->lastname : "";
        $data['{employee_email}']               = isset($employee->email) ? $employee->email : "";

        $data['{customer_question}']            = isset($customer_question) ? $customer_question : "";

        return $data;
    }


    public function sendNotification($params, $hook, $type)
    {
        $customer_question     = null;
        $id_country_prestashop = null;

        switch ($hook['hook']) {
            case 'actionOrderReturn':
                $id_order = $params['orderReturn']->id_order;
                $order    = new Order($params['orderReturn']->id_order, (int)$params['cart']->id_lang);
                $customer = new Customer($params['orderReturn']->id_customer);
                $address  = new Address((int) $params['cart']->id_address_delivery, (int)$params['cart']->id_lang);
                $currency = null;
                $carrier  = null;

                $phone_mobile       = $address->phone_mobile;
                $full_name          = $address->firstname . " " . $address->lastname;

                $id_employee = null;
                $employee    = null;
                $product     = null;

                $customer_question = $params['orderReturn']->question;

                $customer_id_lang   = $customer->id_lang;

                $id_country_prestashop = $address->id_country;

                break;

            case 'actionProductDelete':
                $id_order = null;
                $order    = null;
                $customer = null;
                $address  = null;
                $currency = null;
                $carrier  = null;

                $phone_mobile       = null;
                $full_name          = null;

                $id_employee = $params['cookie']->id_employee;

                $employee = new Employee($id_employee);
                $product  = $params['product'];

                break;

            case 'actionProductOutOfStock':
                $id_order = null;
                $order    = null;
                $customer = null;
                $address  = null;
                $currency = null;
                $carrier  = null;

                $phone_mobile       = null;
                $full_name          = null;
                $employee = null;

                $product  = new Product($params['id_product']);
                break;

            case 'actionCustomerAccountAdd':
                $id_order = null;
                $order    = null;
                $customer = new Customer($params['newCustomer']->id);
                $address  = null;
                $currency = null;
                $carrier  = null;
                $product  = null;
                $employee = null;

                $customer_id_lang   = $params['newCustomer']->id_lang;
                $full_name          = $params['newCustomer']->firstname . " " . $params['newCustomer']->lastname;
                $phone_mobile       = null;

                if (isset($params['cart']->id_address_delivery)) {
                    if ($params['cart']->id_address_delivery) {
                        $address_cust    = new Address(
                            (int) $params['cart']->id_address_delivery,
                            (int)$params['cart']->id_lang
                        );
                        $phone_mobile    = $address_cust->phone_mobile;
                    }
                }
                break;

            default:
                if (isset($params['id_order'])) {
                    $id_order   = $params['id_order'];
                } elseif (isset($params['order'])) {
                    $id_order   = $params['order']->id;
                }

                $address    = new Address((int) $params['cart']->id_address_delivery, (int)$params['cart']->id_lang);
                $order      = new Order($id_order, (int)$params['cart']->id_lang);
                $customer   = new Customer($params['cart']->id_customer);
                $currency   = new Currency($order->id_currency, (int)$params['cart']->id_lang);
                $carrier    = new Carrier($order->id_carrier, (int)$params['cart']->id_lang);
                $product    = null;
                $employee   = null;

                $phone_mobile       = $address->phone_mobile;
                $full_name          = $address->firstname . " " . $address->lastname;

                $customer_id_lang   = $customer->id_lang;
                $id_country_prestashop = $address->id_country;
                break;
        }

        $ps_data = $this->getDataActionOrderStatusPostUpdate(
            $id_order,
            $order,
            $customer,
            $address,
            $currency,
            $carrier,
            $product,
            $employee,
            $customer_question
        );

        $login          = (string) Configuration::get('MENSAGIA_LOGIN_EMAIL');
        $password       = (string) Configuration::get('MENSAGIA_LOGIN_PASSWORD');
        $connected      = (bool) Configuration::get('MENSAGIA_AUTHENTICATED');
        $prefix_mode    = (string) Configuration::get('MENSAGIA_PREFIX_MODE');

        if ($connected) {
            $authentication = $this->mensagiaSDK->authenticate($login, $password);

            // miramos si se autentifica y puede enviar SMS
            if ($authentication['result'] != 'error') {
                if ($type == 'customer') {
                    if ($phone_mobile) {
                        // limpiamos el número de caracteres extraños
                        $phone_mobile = $this->mensagiaSDK->cleanNumber($phone_mobile);

                        if ($prefix_mode == 'check_prefixs') {
                            // Buscamos el pais de la compra
                            $country_iso_code_address = Country::getIsoById($id_country_prestashop);

                            // Buscamos el país en Mensagia
                            $mensagia_country = MensagiaCountry::getMensagiaCountryByISO($country_iso_code_address);

                            // comprobamos prefijo del número
                            $phone_mobile = $this->mensagiaSDK->checkAndSetPrefix(
                                $phone_mobile,
                                $mensagia_country['phone']
                            );
                        }

                        // comprobamos que $phone_mobile no sea null despues de comprobaciones anteriores
                        if ($phone_mobile) {
                            // buscamos si hay un mensaje
                            $message = MensagiaSMSNotification::getMessagesNotification(
                                (int) $hook['id'],
                                $customer_id_lang
                            );

                            if (isset($message[0]['message'])) {
                                $sms = $message[0]['message'];

                                $sms_transformed = $this->transformSMSToSend($sms, $ps_data);

                                $sendSMS = $this->mensagiaSDK->sendSMS(
                                    $phone_mobile,
                                    $sms_transformed,
                                    (string) Configuration::get('MENSAGIA_API_CONFIGURATION')
                                );

                                if ($sendSMS['result'] == 'error') {
                                    return $this->returnResponseErrors($sendSMS);
                                } else {
                                    return array(
                                        'result'    => 'success'
                                    );
                                }
                            }
                        } else {
                            return array(
                                'result'        => 'error-whithout-number',
                                'full_name'     => $full_name,
                            );
                        }
                    } else {
                        return array(
                            'result'        => 'error-whithout-number',
                            'full_name'     => $full_name,
                        );
                    }
                }

                $phone_mobile   = null;
                $message        = null;

                if ($type == 'admin') {
                    // buscamos los admins
                    $admins = MensagiaAdmin::getAdmins();
                    $numbers = array();

                    if (count($admins)) {
                        foreach ($admins as $admin) {

                            // limpiamos el número de caracteres extraños
                            $phone_mobile = $this->mensagiaSDK->cleanNumber($admin['number']);

                            if ($phone_mobile)
                                array_push($numbers, $phone_mobile);
                        }

                        $phone_mobile = implode(',', $numbers);
                    }

                    if ($phone_mobile) {
                        // buscamos si hay un mensaje
                        $message = MensagiaSMSNotification::getMessagesNotification((int) $hook['id'], 0);

                        if (isset($message[0]['message'])) {
                            $sms = $message[0]['message'];

                            $sms_transformed = $this->transformSMSToSend($sms, $ps_data);

                            $sendSMS = $this->mensagiaSDK->sendSMS(
                                $phone_mobile,
                                $sms_transformed,
                                (string) Configuration::get('MENSAGIA_API_CONFIGURATION')
                            );

                            if ($sendSMS['result'] == 'error') {
                                return $this->returnResponseErrors($sendSMS);
                            } else {
                                return array(
                                    'result'    => 'success'
                                );
                            }
                        }
                    } else {
                        return array(
                            'result'        => 'error-whithout-number',
                            'full_name'     => $full_name,
                        );
                    }
                }
            } else {
                return array(
                    'result'        => 'error-authentification-failed',
                    'message'       => 'No SMS notification was sent because you are not connected to Mensagia. '.
                        'Re-enter your login details.',
                );
            }
        } else {
            return array(
                'result'        => 'error-no-connected',
                'message'       => 'No SMS notification was sent because you are not connected to Mensagia. '.
                    'Re-enter your login details.',
            );
        }
    }


    private function transformSMSToSend($sms, $ps_data)
    {
        preg_match_all('/\{([^}]+)\}/', $sms, $matches);

        if (isset($matches[1])) {
            $mergeTagsFound = $matches[1];

            foreach ($mergeTagsFound as $tag) {
                if (isset($ps_data['{'.$tag.'}'])) {
                    $sms = str_replace('{'.$tag.'}', $ps_data['{'.$tag.'}'], $sms);
                } else {
                    $sms = str_replace('{'.$tag.'}', '', $sms);
                }
            }
        }

        return $sms;
    }


    public function returnResponseErrors($response)
    {
        $prefix = "[Mensagia SMS] ";

        if (isset($response['errors']['validation_errors'])) {
            $validations_errors = array();

            foreach ($response['errors']['validation_errors'] as $error_code => $error_message) {
                if (!is_array($error_message)) {
                    array_push($validations_errors, $prefix.$error_code.": ".$error_message);
                } else {
                    foreach ($error_message as $index => $value) {
                        if (!is_array($value)) {
                            array_push($validations_errors, $prefix.$error_code.": ".$index." ".$value);
                        } else {
                            foreach ($value as $msg) {
                                array_push($validations_errors, $prefix.$error_code.": ".$index." ".$msg);
                            }
                        }
                    }
                }
            }

            return array(
                'result'            => 'error',
                'error_messages'    => $validations_errors
            );
        } else {
            $message_error = $prefix.$response['errors']['code'];

            $message_error .= ": ".$response['errors']['message'];

            return array(
                'result'            => 'error',
                'error_messages'    => array($message_error)
            );
        }
    }

    private function spanishDates($date)
    {
        if ($date) {
            $parts = explode(' ', $date);

            if (count($parts) > 1) {
                list($any, $mes, $dia) = explode('-', $parts[0], 3);

                return $dia."-".$mes."-".$any." ".$parts[1];
            } else {
                list($any, $mes, $dia) = explode('-', $date, 3);

                return $dia."-".$mes."-".$any;
            }
        } else {
            return $date;
        }
    }
}
