<?php
/**
 * 2007-2015 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author PrestaShop SA <contact@prestashop.com>
 *  @copyright  2007-2015 PrestaShop SA
 *  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

require_once(_PS_MODULE_DIR_ . 'mensagiaprestashop/classes/MensagiaSDK.php');
require_once(_PS_MODULE_DIR_ . 'mensagiaprestashop/mensagiaprestashop.php');
require_once(_PS_CLASS_DIR_ . 'controller/ModuleAdminController.php');

class MensagiaPrestashopCallbackBlacklist
{
    private $callback;

    public function __construct($callback)
    {
        $this->callback = $callback;
    }

    public function process()
    {
        // si no esta en la lista negra permitidas, salimos
        $allowed_blacklists = explode(',', Configuration::get('MENSAGIA_CALLBACKS_BLACKLISTS'));
        if (!in_array($this->callback['channel'], $allowed_blacklists))
            return false;

        // si solo nos envian el número de teléfono, buscamos en Address el id de los customers que lo tienen
        if ($this->callback['contact_number'] and !$this->callback['contact_email']){
            $array_id_customers = [];
            $query = 'SELECT id_customer FROM `'._DB_PREFIX_.'address` WHERE phone_mobile = "'.$this->callback['contact_number'].'";';
            $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($query);
            if ($result) {
                foreach($result as $res){
                    if (isset($res['id_customer']))
                        array_push($array_id_customers, $res['id_customer']);
                }
            }
            $where = 'id_customer IN ('.implode(',', $array_id_customers).')';

            // si no hay clientes porque los han borrado en prestashop salimos
            if (!count($array_id_customers))
                return false;
        } else
            $where = 'email = "'.$this->callback['contact_email'].'"';

        $newsletter             =  ($this->callback['type'] === 'remove_from_blacklist') ? 1 : 0;
        $newsletter_date_add    =  ($this->callback['type'] === 'add_to_blacklist') ? date('Y-m-d H:i:s') : "0000-00-00 00:00:00";

        $query = '
        UPDATE `'._DB_PREFIX_.'customer`
        SET newsletter = '.$newsletter.',
        ip_registration_newsletter = "138.201.165.70",       
        newsletter_date_add = "'.$newsletter_date_add.'",
        date_upd = "'.date('Y-m-d H:i:s').'"
        WHERE '.$where.';';

        Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($query);
    }
}
