{*
* 2007-2016 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <info@mensagia.com>
*  @copyright  2017 Sinermedia
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}

{$output}

<form id="" class="defaultForm form-horizontal mensagiaprestashop" action="{$action}" method="post" enctype="multipart/form-data" autocomplete="off" role="presentation">
    <input type="hidden" name="submitmensagiaprestashop" value="1">

    <div class="panel" id="fieldset_0">

        <div class="panel-heading">
            <i class="icon-gear"></i> {l s='Connect your Mensagia account with PrestaShop' mod='mensagiaprestashop'}
        </div>

        <div class="form-wrapper panel-body">

            {if (! $connected)}
                <div class="alert alert-danger">{l s='You must connect your Mensagia account to use this module' mod='mensagiaprestashop'}</div>
            {/if}

            <div class="form-group">

                <label class="control-label col-lg-3 required">
                    {l s='Mensagia\'s email access' mod='mensagiaprestashop'}
                </label>

                <div class="col-lg-9">
                    <input type="text" name="MENSAGIA_LOGIN_EMAIL" id="MENSAGIA_LOGIN_EMAIL" value="{$login}" class="" size="40" required="required"   autocomplete="off">
                </div>

            </div>

            <div class="form-group">

                <label class="control-label col-lg-3 required">
                    {l s='Mensagia\'s password access' mod='mensagiaprestashop'}
                </label>

                <div class="col-lg-9">
                    <div class="input-group fixed-width-lg">
                        <span class="input-group-addon"><i class="icon-key"></i></span>
                        <input type="password" id="MENSAGIA_LOGIN_PASSWORD" name="MENSAGIA_LOGIN_PASSWORD" class="" value="" required="required" autocomplete="off">
                    </div>
                </div>

            </div>

            <div class="form-group">

                <label class="control-label col-lg-3">

                </label>

                <div class="col-lg-9">
                    {if ($connected)}
                        <span style="color:green;font-weight:bold"><i class="icon-thumbs-o-up" aria-hidden="true"></i>&nbsp;&nbsp;{l s='Account correctly connected to Mensagia' mod='mensagiaprestashop'}</span><br>
                    {/if}
                </div>

            </div>


            {if ($balance)}
                <div class="form-group">

                    <label class="control-label col-lg-3">
                        {l s='Available balance' mod='mensagiaprestashop'}
                    </label>

                    <div class="col-lg-9">
                        <div class="input-group fixed-width-lg">
                            <div class="balance" style="margin-top:8px;font-weight: bold;">{$balance}</div>
                        </div>
                    </div>

                </div>
            {/if}

            <div class="form-group">

                <label class="control-label col-lg-3">

                </label>

                <div class="col-lg-9">
                    <div style="margin-top:7px;"><i class="icon-angle-double-right" aria-hidden="true"></i> <a target='_blank' href="https://mensagia.com/signup">{l s='Create new account' mod='mensagiaprestashop'}</a></div>
                    <div style="margin-top:5px;"><i class="icon-angle-double-right" aria-hidden="true"></i> <a target='_blank' href="https://mensagia.com/mrequests/create?type=1">{l s='Add balance' mod='mensagiaprestashop'}</a></div>
                    <div style="margin-top:5px;"><i class="icon-angle-double-right" aria-hidden="true"></i> <a target='_blank' href="https://mensagia.com/forgot_password">{l s='Remember password' mod='mensagiaprestashop'}</a></div>
                </div>

            </div>

        </div><!-- /.form-wrapper -->

        <div class="panel-footer">
            <button type="submit" value="1" id="configuration_form_submit_btn" name="submitmensagiaprestashop" class="btn btn-default pull-right">
                <i class="process-icon-save"></i> {l s='Save' mod='mensagiaprestashop'}
            </button>
        </div>

    </div>
</form>



<div class="panel">
    <div class="panel-heading"><i class="icon-mobile"></i> {l s='Send API settings and source address' mod='mensagiaprestashop'}</div>
    <div class="panel-body">

        <form action="{$action}" method="post" class="defaultForm form-horizontal mensagiaprestashop">

            {if ($connected)}

                {if (count($api_configurations))}

                    {if (!$api_configuration)}
                        <div class="alert alert-warning">
                            <b>{l s='Attention!' mod='mensagiaprestashop'}</b>: {l s='You must choose a source address configuration in order to use SMS Notifications' mod='mensagiaprestashop'}
                        </div>
                    {/if}

                    <div class="form-group">
                        <label class="control-label col-lg-3 required">
                            {l s='Choose configuration to send' mod='mensagiaprestashop'}
                        </label>

                        <div class="col-lg-9">
                            <select name="sapi_configuration" id="sapi_configuration" required style="width:250px !important;">
                                    <option value="">{l s='Choose a configuration to send...' mod='mensagiaprestashop'}</option>
                                {foreach from=$api_configurations item=curr}
                                    <option sender_name="{$curr['sender_name']}" allow_service_number_alias="{if ($curr['allow_service_number_alias'])}true{else}false{/if}" {if ($curr['name'] == $api_configuration)}selected{/if} value="{$curr['name']}">{$curr['name']}</option>
                                {/foreach}
                            </select>
                        </div>
                    </div>

                    <div class="form-group groupSourceAddress">

                        <label class="control-label col-lg-3">
                            {l s='The source address will be' mod='mensagiaprestashop'}:
                        </label>

                        <div class="col-lg-9">
                            <div class="remitente" style="margin-top:8px;font-weight: bold;"></div>
                        </div>

                    </div>
                {else}
                    <div class="alert alert-warning">
                        <b>{l s='Attention!' mod='mensagiaprestashop'}</b>: {l s='You do not have any configuration to send created in Mensagia. You must create one in:' mod='mensagiaprestashop'} <a target='_blank' href='https://mensagia.com/api/configurations/create'>{l s='Configuraciones de envio API en Mensagia' mod='mensagiaprestashop'}</a>
                    </div>
                {/if}

            {else}
                <div class="alert alert-info">
                    <b>{l s='Attention!' mod='mensagiaprestashop'}</b>: {l s='You must first configure your access to Mensagia before configuring the configuration to send.' mod='mensagiaprestashop'}
                </div>
            {/if}

    </div>

    <div class="panel-footer">
        <button type="submit" value="1" id="api_configurations" name="api_configurations" class="btn btn-default pull-right">
            <i class="process-icon-save"></i> {l s='Save' mod='mensagiaprestashop'}
        </button>
    </div>

    </form>


</div>


<div class="panel">
    <div class="panel-heading"><i class="icon-users"></i> {l s='Shop administrators' mod='mensagiaprestashop'}</div>
    <div class="panel-body bodyForms">

        {if count($admins) }

        <p>{l s='Create store administrators to recieve SMS notifications of administrator type' mod='mensagiaprestashop'}</p>

        <table class="table table-hover" width="70%" cellpadding="5" cellspacing="10" align="center">
            <thead>
            <tr>
                <th><b>{l s='Name' mod='mensagiaprestashop'}</b></th>
                <th><b>{l s='Phone number' mod='mensagiaprestashop'}</b></th>
                <th><b>{l s='Delete' mod='mensagiaprestashop'}</b></th>
            </tr>
            </thead>
            <tbody>

                {foreach from=$admins item=curr}
                    <tr>
                        <td height="50">{$curr['name']}</td>
                        <td>{$curr['number']}</td>
                        <td>
                            <form action="{$action}" method="post">
                                <input type="hidden" name="admin_id" value="{$curr['id']}">
                                <button type="submit" class="btn btn-danger btn-delete-admin" name="delete_admins"><i class="icon-trash"></i> {l s='Delete' mod='mensagiaprestashop'}</button>
                            </form>
                        </td>
                    </tr>
                {/foreach}

            </tbody>
        </table>

        {else}
            <div class="alert alert-warning">
                <b>{l s='Attention!' mod='mensagiaprestashop'}</b>: {l s='You do not have administrators created, you must create at least one to use SMS Notifications.' mod='mensagiaprestashop'}
            </div>

            <p>{l s='Create store administrators to recieve SMS notifications of administrator type.' mod='mensagiaprestashop'}.</p>
        {/if}

    </div>
    <div class="panel-footer">
        <button type="submit" value="1" id="api_configurations" name="api_configurations" class="btn btn-default pull-right" data-toggle="modal" data-target="#myModal">
            <i class="process-icon-edit"></i> {l s='Create administrator' mod='mensagiaprestashop'}
        </button>
    </div>
</div>


<div class="panel">
    <div class="panel-heading"><i class="icon-phone"></i> {l s='Management of international prefixes on mobile numbers' mod='mensagiaprestashop'}</div>
    <div class="panel-body">

        <form action="{$action}" method="post" class="defaultForm form-horizontal mensagiaprestashop">

            {if (!$prefix_mode)}
                <div class="alert alert-danger">
                    <b>{l s='Attention!' mod='mensagiaprestashop'}</b>: {l s='You must choose how we will handle the prefixes of your contact\'s mobile numbers.' mod='mensagiaprestashop'}
                </div>
            {/if}

            <p>{l s='In order to send SMS we need numbers to have prefixes. Tell us how we should proceed with your contacts\'s mobile numbers ' mod='mensagiaprestashop'}:</p>

            <div class="form-group" style="margin-top:30px;">
                <label class="control-label col-lg-4">
                    {l s='Are the mobile numbers of your contacts stored with the country code?' mod='mensagiaprestashop'}
                </label>

                <div class="col-lg-8">
                    <p class="radio" style="margin-top:0px !important;">
                        <label for="radioNO" style="font-weight:bold;"><input type="radio" id="radioNO" name="prefix_mode" class="" {if ($prefix_mode == 'check_prefixs')}checked{/if} value="check_prefixs">{l s='It is not being verified that they keep the mobile number with a prefix. If the mobile number has no prefix, add the prefix of the country of the contact. ' mod='mensagiaprestashop'}</label> <br>
                    </p>
                    <p class="radio">
                        <label for="radioSI" style="font-weight:bold;"><input type="radio" id="radioSI" name="prefix_mode" class="" {if ($prefix_mode == 'with_prefixs')}checked{/if} value="with_prefixs">{l s='Yes, all numbers are stored with their corresponding country code.' mod='mensagiaprestashop'}</label>
                    </p>
                </div>
            </div>

        </div>

        <div class="panel-footer">
            <button type="submit" value="1" id="prefix_mode" name="prefix_mode_submit" class="btn btn-default pull-right">
                <i class="process-icon-save"></i> {l s='Save' mod='mensagiaprestashop'}
            </button>
        </div>

    </form>

</div>


<div class="panel">
    <div class="panel-heading"><i class="icon-user"></i> Actualizar campo boletín desde Mensagia</div>
    <div class="panel-body">

        <p>{l s='The field [1]Newsletter[/1] in Prestashop indicates if your client gives consent to send him communications.' tags=['<i>'] mod='mensagiaprestashop'}</p>
        <p>{l s='You can automatically update the [1]Newsletter[/1] field of the customers of your store from the shipments you make in Mensagia and thus avoid sending communications to customers who do not wish to receive them, complying with all Data Protection laws. When Mensagia detects that one of your clients does not want to receive further communications and is included in a Black List, we will update the [2]Newsletter[/2] field of your client in Prestashop and deactivate it. On the contrary, if you remove one of your clients from any of the Mensagia Black Lists, we will activate the [3]Newsletter[/3] field in Prestashop for that client.' tags=['<i>', '<i>','<i>'] mod='mensagiaprestashop'}</p>
        <p></p>
        <p></p>

        <div style="background:#eee;border:1px solid #aaa; padding:20px;">
            <div style="margin-bottom:10px;">{l s='To activate this option, you must enter the following URL in the [1]Callback URL[/1] section in Mensagia' tags=['<a target="_blank" href="https://mensagia.com/settings/unsubscribe">'] mod='mensagiaprestashop'}:</div>
            <div style="margin-left:10px;"><b><span class="urlCallback">{str_replace('http', 'https', Tools::getShopDomain(true))}/modules/mensagiaprestashop/callbacks/blacklist.php</span></b> <span class="copyToClipboard" style="margin-left:10px;color:#00aff0;text-decoration: underline;cursor:pointer;">{l s='Copy' mod='mensagiaprestashop'}</span><span class="copied" style="display:none;margin-left:10px;color:green;font-weight: bold;">¡{l s='Copied' mod='mensagiaprestashop'}!</span></div>

            <p style="font-size:12px;"><br><i>{l s='Once you have saved the URL in Mensagia, your Prestashop will begin to update the Newsletter field automatically with the requests that come from Mensagia' mod='mensagiaprestashop'}.</i></p>
        </div>

        <br><b>¡{l s='Attention' mod='mensagiaprestashop'}!:</b> {l s='When you make communications by email in Mensagia, you must activate the option [1]Send to the BlackList[/1] so that we can update the field [2]Newsletter[/2] of your customers in Prestashop' tags=['<a href="https://mensagia.com/docs/campanas-de-email/1051#mail_blacklist">','<i>'] mod='mensagiaprestashop'}.

        <form action="{$action}" method="post" class="defaultForm form-horizontal mensagiaprestashop">

        <br><br><p>{l s='Choose which Blacklists have permission to modify the field [1]Newsletter[/1]' tags=['<i>'] mod='mensagiaprestashop'}:</p>
        <p class="radio" style="margin-top:0px !important;">
            <label for="radioSMS" style="font-weight:bold;"> <input  {if $mensagia_callbacks_blacklists|strstr:"sms"} checked {/if} type="checkbox" id="radioSMS" name="sms_blacklist" class="" value="sms"> {l s='SMS BlackList' mod='mensagiaprestashop'}</label> <br>
        </p>
        <p class="radio">
            <label for="radioEmail" style="font-weight:bold;"> <input {if $mensagia_callbacks_blacklists|strstr:"mail"} checked {/if}  type="checkbox" id="radioEmail" name="mail_blacklist" class=""  value="mail"> {l s='Email BlackList' mod='mensagiaprestashop'}</label>
        </p>
        <p class="radio">
            <label for="radioVoz" style="font-weight:bold;"> <input {if $mensagia_callbacks_blacklists|strstr:"voice"} checked {/if} type="checkbox" id="radioVoz" name="voz_blacklist" class=""  value="voice"> {l s='Voice BlackList' mod='mensagiaprestashop'}</label>
        </p>
    </div>
    <div class="panel-footer">
        <button type="submit" value="1" id="blacklist_with_newsletter_submit" name="blacklist_with_newsletter_submit" class="btn btn-default pull-right">
            <i class="process-icon-save"></i> {l s='Save' mod='mensagiaprestashop'}
        </button>
    </div>
    </form>
</div>

{include file="./../partials/logoFooter.tpl"}

<!-- Modal -->
<div class="modal fade" id="myModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="myModalLabel"><i class="icon-user"></i> {l s='Create administrator' mod='mensagiaprestashop'}</h4>
            </div>

            <form action="{$action}" method="post">

                <div class="modal-body">

                    <div class="form-group row">
                        <label class="control-label col-lg-4 required" label-for="admin_name">
                            {l s='Name' mod='mensagiaprestashop'}
                        </label>
                        <div class="col-lg-8">
                            <input type="text" name="admin_name" id="admin_name" value="" class="required" size="40" required="required">
                        </div>
                    </div>

                    <div class="form-group row">
                        <label class="control-label col-lg-4 required" label-for="admin_name">
                            {l s='Phone number' mod='mensagiaprestashop'}
                        </label>
                        <div class="col-lg-8">
                            <input type="text" name="admin_mobile" id="admin_mobile" value="" class="required" size="40" required="required">
                            <span id="helpBlock" class="help-block">{l s='Add the number with a prefix, withour the + sign and without spaces. ' mod='mensagiaprestashop'}</span>
                        </div>
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">{l s='Cancel' mod='mensagiaprestashop'}</button>
                    <button type="submit" class="btn btn-primary btn-save-admins" name="create_admins">{l s='Save' mod='mensagiaprestashop'}</button>
                </div>

            </form>

        </div>
    </div>
</div>


<style>
    .bootbox-close-button {
        display:none !important;
    }
</style>

<script src="{$bootboxDir}" type="text/javascript"></script>
<script src="{$jsDir}" type="text/javascript"></script>


<script>
    var no_dinamic_sender  = '{$nodinamicsendertxt}';
</script>