<?php
/**
 * 2007-2015 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author PrestaShop SA <contact@prestashop.com>
 *  @copyright  2007-2015 PrestaShop SA
 *  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

class MensagiaSMSNotification extends ObjectModel
{
    /** @var string Name */
    public $name;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'mensagia_sms_notifications',
        'primary' => 'id',
        'multilang' => false,
        'fields' => array(
            'hook' => array('type' => self::TYPE_STRING),
            'option_id' =>    array('type' => self::TYPE_STRING, 'validate' => 'isBool'),
            'active' =>        array('type' => self::TYPE_STRING, 'validate' => 'isColor'),
        ),
    );


    public static function getNotifications($type = null)
    {
        if ($type !== null) {
            $where = " WHERE type = '".$type."' ";
        } else {
            $where = "";
        }

        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
            SELECT *
            FROM `'._DB_PREFIX_.'mensagia_sms_notifications` '.$where.'     
            ORDER BY `id` ASC');

        return $result;
    }



    public static function getMessagesNotification($mensagia_sms_notification_id, $lang_id)
    {
        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
            SELECT `message`
            FROM `'._DB_PREFIX_.'mensagia_sms_notifications_lang`
            WHERE mensagia_sms_notification_id = '.$mensagia_sms_notification_id.' AND lang_id = '.$lang_id.'
            ORDER BY `id` ASC');

        return $result;
    }

    public static function getAllMessagesNotifications()
    {
        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
            SELECT *
            FROM `'._DB_PREFIX_.'mensagia_sms_notifications_lang`        
            ORDER BY `id` ASC');

        return $result;
    }


    public static function getHooks($type, $hook, $option_id = null)
    {
        if ($option_id !== null) {
            $where = " AND option_id = ".$option_id." ";
        } else {
            $where = "";
        }

        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
            SELECT *
            FROM `'._DB_PREFIX_.'mensagia_sms_notifications`
            WHERE hook = "'.$hook.'" AND type = "'.$type.'" '.$where.'      
            ORDER BY `id` ASC');

        return $result;
    }

    /*
    public static function getMessageNotificationLang($type, $hook)
    {
        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
            SELECT *
            FROM `'._DB_PREFIX_.'mensagia_sms_notifications`
            WHERE hook = "'.$hook.'" AND type = "'.$type.'"
            ORDER BY `id` ASC');

        return $result;
    }
    */

    /**
     * Get all available order statuses
     *
     * @param int $id_lang Language id for status name
     * @return array Order statuses
     */
    public static function getAllOrderStates()
    {
        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
            SELECT *
            FROM `'._DB_PREFIX_.'order_state` os
            LEFT JOIN `'._DB_PREFIX_.'order_state_lang` osl ON (os.`id_order_state` = osl.`id_order_state`)
            WHERE deleted = 0
            ORDER BY `name` ASC');
        return $result;
    }

    public static function isHookEnabled($hook, $type, $option_id = null)
    {
        if ($option_id !== null) {
            $where = " AND option_id = ".$option_id." ";
        } else {
            $where = "";
        }

        $query = 'SELECT * FROM `'._DB_PREFIX_.'mensagia_sms_notifications` 
            WHERE hook = "'.$hook.'" AND active=1 AND type = "'.$type.'" '.$where;

        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS($query);

        if (count($result)) {
            if (isset($result[0])) {
                return $result[0];
            } else {
                return false;
            }
        } else {
            return false;
        }
    }



    public static function transformNotificationsToCheck($notifications)
    {
        $new_notifications = array();

        if ($notifications) {
            foreach ($notifications as $notification) {
                if ($notification['hook'] == 'actionOrderStatusPostUpdate') {
                    $new_notifications[$notification['type'].'_actionOrderStatusPostUpdate_'.$notification['option_id']]
                        = (int) $notification['active'];
                } else {
                    $new_notifications[$notification['type'].'_'.$notification['hook']] = (int) $notification['active'];
                }
            }
        }

        return $new_notifications;
    }

    public static function updateNotification($data)
    {
        $hook                        = $data['hook'];
        $htype                       = $data['htype'];
        $hid                         = (int) isset($data['hid']) ? $data['hid'] : null;
        $active                      = (int) $data['active'];

        if ($hid) {
            $query = '
            UPDATE `'._DB_PREFIX_.'mensagia_sms_notifications`
            SET active = '.$active.'
            WHERE hook = "'.$hook.'" AND option_id = '.$hid.' AND type = "'.$htype.'" ;';
        } else {
            $query = '
            UPDATE `'._DB_PREFIX_.'mensagia_sms_notifications`
            SET active = '.$active.'
            WHERE hook = "'.$hook.'" AND type = "'.$htype.'" ;';
        }

        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->execute($query);

        if ($result) {
            echo "true";
        } else {
            echo "false";
        }
    }


    public static function updateTextNotifications($data)
    {
        $notifications = json_decode($data['json']);

        $errors = array();

        if ($notifications) {
            foreach ($notifications as $notification) {
                $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->execute('
                    UPDATE `'._DB_PREFIX_.'mensagia_sms_notifications_lang`
                    SET message = "'.$notification->text.'" 
                    WHERE id = '.$notification->id.' ;');

                if (!$result) {
                    array_push($errors, $notification->text);
                }
            }
        }

        if (empty($errors)) {
            echo "true";
        } else {
            echo "false";
        }
    }


    /**
     * Get all available order statuses
     *
     * @param int $id_lang Language id for status name
     * @return array Order statuses
     */
    public static function getOrderStates($id_lang)
    {
        $cache_id = 'OrderState::getOrderStates_'.(int)$id_lang;

        if (!Cache::isStored($cache_id)) {
            $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
            SELECT *
            FROM `'._DB_PREFIX_.'order_state` os
            LEFT JOIN `'._DB_PREFIX_.'order_state_lang` osl ON (os.`id_order_state` = osl.`id_order_state` 
                AND osl.`id_lang` = '.(int)$id_lang.')
            WHERE deleted = 0
            ORDER BY `name` ASC');
            Cache::store($cache_id, $result);
            return $result;
        }
        return Cache::retrieve($cache_id);
    }
}
