<?php
/**
 * 2007-2015 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author PrestaShop SA <contact@prestashop.com>
 *  @copyright  2007-2015 PrestaShop SA
 *  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

class MensagiaCountry extends ObjectModel
{
    /** @var string Name */
    public $name;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'mensagia_countries',
        'primary' => 'id',
        'multilang' => false,
        'fields' => array(
            'code'                  => array('type' => self::TYPE_STRING, 'validate' => 'isString'),
            'name'                  => array('type' => self::TYPE_STRING, 'validate' => 'isString'),
            'native'                => array('type' => self::TYPE_STRING, 'validate' => 'isString'),
            'phone'                 => array('type' => self::TYPE_STRING, 'validate' => 'isString'),
            'continent'             => array('type' => self::TYPE_STRING, 'validate' => 'isString'),
            'capital'               => array('type' => self::TYPE_STRING, 'validate' => 'isString'),
            'currency'              => array('type' => self::TYPE_STRING, 'validate' => 'isString'),
            'languages'             => array('type' => self::TYPE_STRING, 'validate' => 'isString'),
            'min_length_number'     => array('type' => self::TYPE_INT, 'validate' => 'isNumeric'),
            'max_length_number'     => array('type' => self::TYPE_INT, 'validate' => 'isNumeric'),
            'allowed_firsts_number' => array('type' => self::TYPE_STRING, 'validate' => 'isString'),
            'name_en'               => array('type' => self::TYPE_STRING, 'validate' => 'isString'),
        ),
    );


    public static function getMensagiaCountryByISO($code)
    {
        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
            SELECT *
            FROM `'._DB_PREFIX_.'mensagia_countries` 
            WHERE code ="'.$code.'"');

        if (isset($result[0]['id'])) {
            return $result[0];
        } else {
            return null;
        }
    }

    public static function getAdmins()
    {
        $result = Db::getInstance(_PS_USE_SQL_SLAVE_)->executeS('
            SELECT *
            FROM `'._DB_PREFIX_.'mensagia_admins`        
            ORDER BY `id` ASC');

        return $result;
    }

    public static function create($name, $number)
    {
        $result = Db::getInstance()->Execute("INSERT INTO " . _DB_PREFIX_ . "mensagia_admins 
             (`name`, `number`) VALUES ('".$name."', '".$number."');");

        if ($result) {
            return true;
        } else {
            return false;
        }
    }


    public static function remove($id)
    {
        $result = Db::getInstance()->Execute("DELETE FROM " . _DB_PREFIX_ . "mensagia_admins 
             WHERE id=$id;");

        if ($result) {
            return true;
        } else {
            return false;
        }
    }

    public static function exists($number)
    {
        $result = Db::getInstance()->ExecuteS("SELECT * FROM " . _DB_PREFIX_ . "mensagia_admins 
             WHERE number='".$number."';");

        if (isset($result[0])) {
            return true;
        } else {
            return false;
        }
    }
}
