<?php
/**
 * 2007-2015 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author PrestaShop SA <contact@prestashop.com>
 *  @copyright  2007-2015 PrestaShop SA
 *  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

require_once(_PS_MODULE_DIR_ . 'mensagiaprestashop/models/MensagiaSMSNotification.php');

class AdminMensagiaNotificationsController extends ModuleAdminController
{
    public function __construct()
    {
        parent::__construct();
    }


    public function init()
    {
        $this->bootstrap = true;
        parent::init();
    }


    public function initToolBarTitle()
    {
        $module = Module::getInstanceByName('mensagiaprestashop');
        $this->toolbar_title[] = $module->l('Notifications');
    }


    public function initContent()
    {
        parent::initContent();

        $show_content = true;
        $url_redirect = $this->context->link->getAdminLink('AdminModules') . '&configure=' . Tools::safeOutput($this->module->name);

        if (! (bool) Configuration::get('MENSAGIA_AUTHENTICATED') or !MensagiaAdmin::countAdmins()
            or !(bool) Configuration::get('MENSAGIA_PREFIX_MODE') or
            !(bool) Configuration::get('MENSAGIA_API_CONFIGURATION')) {
            $show_content = false;
        }

        $actual_language_id = $this->context->employee->id_lang;

        //$orderStates = OrderState::getOrderStates($this->context->language->id);
        $orderStates = MensagiaSMSNotification::getAllOrderStates();
        $hooksOrderStatesCustomer = MensagiaSMSNotification::getHooks(
            'customer',
            'actionOrderStatusPostUpdate'
        );
        $hooksOrderStatesAdmin    = MensagiaSMSNotification::getHooks(
            'admin',
            'actionOrderStatusPostUpdate'
        );
        $orderStatesNames = array();

        // transform $orderStates
        $orderArray = array();
        $order_names = array();

        if ($orderStates) {
            foreach ($orderStates as $order) {
                $orderArray[$order['id_order_state']."_".$order['id_lang']] = $order['name'];

                if ($actual_language_id == $order['id_lang']) {
                    $order_names[$order['id_order_state']] = $order['name'];
                }
            }
        }


        $languages = Language::getLanguages(true, $this->context->shop->id);
        $actual_language_id = $this->context->employee->id_lang;
        $id_lang_default = (int)Configuration::get('PS_LANG_DEFAULT');

        $sMSNotifications = MensagiaSMSNotification::getNotifications();
        $sMSNotificationsList = $sMSNotifications;

        $sMSNotifications = MensagiaSMSNotification::transformNotificationsToCheck($sMSNotifications);
        $sMSNotificationsLang = MensagiaSMSNotification::getAllMessagesNotifications();

        // transform $sMSNotificationsLang
        $notificationsLangArray = array();

        if ($sMSNotificationsLang) {
            foreach ($sMSNotificationsLang as $lang) {
                $notificationsLangArray[$lang['mensagia_sms_notification_id']."_".$lang['lang_id']]['message'] =
                    $lang['message'];
                $notificationsLangArray[$lang['mensagia_sms_notification_id']."_".$lang['lang_id']]['id'] = $lang['id'];
            }
        }


        $idsNamesNotifications = array();

        if ($sMSNotificationsList) {
            foreach ($sMSNotificationsList as $notification) {
                if ($notification['hook'] == 'actionOrderStatusPostUpdate') {
                    $orderStatesNames['actionOrderStatusPostUpdate_'.$notification['id']] =
                            $order_names[$notification['option_id']];
                } else {
                    // aprovechamos aqui para guardar los ids de las notificaciones para luego llamarlas desde
                    // la plantilla
                    $idsNamesNotifications[$notification['type']."_".$notification['hook']] = $notification['id'];
                }
            }
        }

        $admin_lang_default = array();
        $admin_lang_default[0] = array(
            'id_lang'   => 0,
            'name'      => 'Default',
        );

        // buscamos los administradores
        $admins = MensagiaAdmin::getAdmins();

        // buscamos las configuraciones de API creadas
        $api_configuration = (string)Configuration::get('MENSAGIA_API_CONFIGURATION');


        $this->context->smarty->assign(array(
            'idsNamesNotifications'    => $idsNamesNotifications,
            'hooksOrderStatesCustomer' => $hooksOrderStatesCustomer,
            'hooksOrderStatesAdmin'    => $hooksOrderStatesAdmin,
            'orderStatesNames'         => $orderStatesNames,
            'orderStates'              => $orderStates,
            'mensagiaSMSNotifications' => $sMSNotifications,
            'languages'                => $languages,
            'id_lang_default'          => $id_lang_default,
            'actual_language_id'       => $actual_language_id,
            'notificationsLangArray'   => $notificationsLangArray,
            'orderArray'               => $orderArray,
            'admin_lang_default'       => $admin_lang_default,
            'show_content'             => $show_content,
            'admins'                   => $admins,
            'api_configuration'        => $api_configuration,
            'url_redirect'             => $url_redirect,
            'dirTextareaPath'          => _MODULE_DIR_.'mensagiaprestashop/views/templates/admin/'.
                'mensagia_notifications/textarea.tpl',
        ));

        $this->setTemplate("notifications.tpl");
    }

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);
        $this->addJquery();
        $this->addCSS("https://gitcdn.github.io/bootstrap-toggle/2.2.2/css/bootstrap-toggle.min.css");
        $this->addCSS("https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.3/css/select2.min.css");
        $this->addJS("https://gitcdn.github.io/bootstrap-toggle/2.2.2/js/bootstrap-toggle.min.js");
        $this->addJS(_MODULE_DIR_.'mensagiaprestashop/views/js/notifications.js');
    }
}
