<?php
/**
 * 2007-2015 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author    PrestaShop SA <contact@prestashop.com>
 *  @copyright 2007-2015 PrestaShop SA
 *  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

/**
 * 2007-2015 PrestaShop
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License (AFL 3.0)
 * that is bundled with this package in the file LICENSE.txt.
 * It is also available through the world-wide-web at this URL:
 * http://opensource.org/licenses/afl-3.0.php
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to http://www.prestashop.com for more information.
 *
 *  @author PrestaShop SA <contact@prestashop.com>
 *  @copyright  2007-2015 PrestaShop SA
 *  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 *  International Registered Trademark & Property of PrestaShop SA
 */

class AdminMensagiaExportController extends ModuleAdminController
{
    public function __construct()
    {
        parent::__construct();
    }


    public function init()
    {
        $this->name      = "mensagiaprestashop";
        $this->bootstrap = true;
        parent::init();
    }


    public function initToolBarTitle()
    {
        $module = Module::getInstanceByName('mensagiaprestashop');
        $this->toolbar_title[]  = $module->l('Export to Mensagia');
        $this->meta_title       = $module->l('Export to Mensagia');
    }

    public function initContent()
    {
        parent::initContent();

        $language_id = $this->context->employee->id_lang;

        $groups = Group::getGroups($language_id);

        if (! (bool) Configuration::get('MENSAGIA_AUTHENTICATED')
            or !(bool) Configuration::get('MENSAGIA_PREFIX_MODE')) {
            Tools::redirectAdmin($this->context->link->getAdminLink('AdminModules') . '&configure=' .
                Tools::safeOutput($this->module->name));
        }

        // buscamos date_format
        $language = Language::getLanguage((int)Configuration::get('PS_LANG_DEFAULT'));

        $this->context->smarty->assign(array(
            'shop_name'           => Tools::strtolower(
                str_replace(
                    ' ',
                    '_',
                    Configuration::get('PS_SHOP_NAME') ? Configuration::get('PS_SHOP_NAME') : ""
                )
            ),
            'date_prefix'         => date('Y_m_d_His'),
            'groups'              => $groups,
            'language_id'         => $language_id,
            'default_language_id' => (int)Configuration::get('PS_LANG_DEFAULT'),
            'date_format_lite'    => $language['date_format_lite'],
            'date_format_full'    => $language['date_format_full'],
            'prefix_mode'         => Configuration::get('MENSAGIA_PREFIX_MODE'),
            'action'              => AdminController::$currentIndex . '&configure=' . $this->name .
                '&save' . $this->name . '&token='.Tools::getAdminTokenLite('AdminMensagiaExport'),
        ));

        $this->setTemplate("export.tpl");
    }

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);
        $this->addJquery();
        $this->addJS(_MODULE_DIR_.'mensagiaprestashop/views/js/export.js');
    }
}
